package net.kldp.logviewer.model;

import java.text.SimpleDateFormat;
import java.util.Date;

import net.kldp.logviewer.define.LogDefine;

import org.apache.commons.lang.StringUtils;

/**
 * log viewer    Ѵ.
 * 
 * @author hangumkj
 *
 */
public class LogViewerEntry extends LogViewer {
	private LogViewerGroup group = null;
	private long groupSeq 	= 0l;		// ׷ȣ
	private long seq 		= 0l;		// seq
	private String name 	= "";		// ̸
	private String type 	= "";		// -- 00: 01: ftp
	private String ftpIP 	= "";		// ftp, telnet ip
	private String ftpPort 	= "";		// port
	private String ftpID 	= "";		// id
	private String ftpPass 	= "";		// pass
	private String ftpMode 	= "";		// ftp mode passiv
	private String path 	= "";		// path
	
	//	 @ ϴ yyyy-MM-dd-HH ִٸ ̰  ---ð Ѵ.
	private String realPath = "";
	
	private long delaySecond 	= 0l;	// ۾ֱ 
	private String font			= "";	// styledText  font
	private String fontSize		= "";	// font size
	private String fontcolor	= "";	// font color
	private String backGroundColor 	= "";	// styledText  
	private String statusYn			= "";	// 
	
	private String curBackColor 	= "";	// ׶Ʈ ÷
  	private String lineCount  		= "";   // styled Text Ѱ
  	private String alalrmData		= "";	// ˷ϴ 
  	private String alalrmBackColor  = "";	// ˷ϴ  ߽߰  ׶ ÷
  	private String alarmType 		= "";	// ˷ϴ Ÿ
	

	public LogViewerEntry() {		
	}
	
	public LogViewerEntry(LogViewerGroup group, long groupSeq, long seq, String name, 
			String type, String ftpIP, String ftpPort, String ftpID, String ftpPass, String ftpMode,
			String path, long delaySecond, String font, String fontSize, String fontColor, String backGroundColor,
			String curBackColor, String lineCount, String alalrmData, String alalrmBackColor, String alarmType	
		) {
		
		this.group = group;
		this.groupSeq = groupSeq;
		this.seq = seq;		
		this.name = name;
		this.type = type;
		this.ftpIP = ftpIP;
		this.ftpPort = ftpPort;
		this.ftpID = ftpID;
		this.ftpPass = ftpPass;
		this.ftpMode = ftpMode;
		this.path = path;
		this.delaySecond = delaySecond;
		this.font = font;
		this.fontSize = fontSize;
		this.fontcolor= fontColor;
		this.backGroundColor = backGroundColor;
		
		this.curBackColor 		= curBackColor;		// ׶Ʈ ÷
		this.lineCount  		= lineCount;   		// styled Text Ѱ
		this.alalrmData			= alalrmData;		// ˷ϴ 
		this.alalrmBackColor  	= alalrmBackColor;	// ˷ϴ  ߽߰  ׶ ÷
		this.alarmType 			= alarmType;		// ˷ϴ Ÿ
	}
	
	
	public LogViewerGroup getParent() {
		return this.group;
	}
	public String getPath() {
		return path;
	}
	public void setPath(String path) {
		this.path = path;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
	
	public long getSeq() {
		return seq;
	}

	public void setSeq(long seq) {
		this.seq = seq;
	}

	
	public String getName() {
		return this.name;
	}
	
	public String getBackGroundColor() {
		if("".equals(backGroundColor)) backGroundColor = LogDefine.DEFAULT_BK_COLOR_SET;
		
		return backGroundColor;
	}

	public void setBackGroundColor(String backGroundColor) {
		this.backGroundColor = backGroundColor;
	}

	public long getDelaySecond() {
		if(0l == delaySecond) delaySecond = 3; 
			
		return delaySecond;
	}

	public void setDelaySecond(long delaySecond) {
		this.delaySecond = delaySecond;
	}

	public String getFont() {
		if("".equals(font)) font = "0";
		
		return font;
	}

	public void setFont(String font) {
		this.font = font;
	}

	public String getFontSize() {
		if("".equals(fontSize)) fontSize = "1";
			
		return fontSize;
	}

	public void setFontSize(String fontSize) {
		this.fontSize = fontSize;
	}

	public LogViewerGroup getGroup() {
		return group;
	}

	public void setGroup(LogViewerGroup group) {
		this.group = group;
	}

	public long getGroupSeq() {
		return groupSeq;
	}

	public void setGroupSeq(long groupSeq) {
		this.groupSeq = groupSeq;
	}

	public String getStatusYn() {
		return statusYn;
	}

	public void setStatusYn(String statusYn) {
		this.statusYn = statusYn;
	}


	public String getFontcolor() {
		if("".equals(fontcolor)) fontcolor = LogDefine.DEFAULT_FONT_COLOR_SET;
		
		return fontcolor;
	}


	public void setFontcolor(String fontcolor) {
		this.fontcolor = fontcolor;
	}


	public String getFtpID() {
		return ftpID;
	}


	public void setFtpID(String ftpID) {
		this.ftpID = ftpID;
	}


	public String getFtpIP() {
		return ftpIP;
	}


	public void setFtpIP(String ftpIP) {
		this.ftpIP = ftpIP;
	}


	public String getFtpMode() {
		return ftpMode;
	}


	public void setFtpMode(String ftpMode) {
		this.ftpMode = ftpMode;
	}


	public String getFtpPass() {
		return ftpPass;
	}


	public void setFtpPass(String ftpPass) {
		this.ftpPass = ftpPass;
	}


	public String getFtpPort() {
		return ftpPort;
	}


	public void setFtpPort(String ftpPort) {
		this.ftpPort = ftpPort;
	}


	public String getType() {
		if("".equals(type)) type = "0";
		
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}
	

	public String getAlalrmBackColor() {
		if("".equals(alalrmBackColor)) alalrmBackColor = LogDefine.DEFAULT_ALARM_COLOR_SET;
		return alalrmBackColor;
	}

	public void setAlalrmBackColor(String alalrmBackColor) {
		this.alalrmBackColor = alalrmBackColor;
	}

	public String getAlalrmData() {
		return alalrmData;
	}

	public void setAlalrmData(String alalrmData) {
		this.alalrmData = alalrmData;
	}

	public String getAlarmType() {
		if("".equals(alarmType)) alarmType = "0";
		
		return alarmType;
	}

	public void setAlarmType(String alarmType) {
		this.alarmType = alarmType;
	}

	public String getCurBackColor() {
		if("".equals(curBackColor)) curBackColor = LogDefine.DEFAULT_COURSE_COLOR_SET;
		
		return curBackColor;
	}

	public void setCurBackColor(String curBackColor) {
		this.curBackColor = curBackColor;
	}

	public String getLineCount() {
		if("".equals(lineCount)) lineCount = LogDefine.DEFAULT_LINE_CNT;
		
		return lineCount;
	}

	public void setLineCount(String lineCount) {
		this.lineCount = lineCount;
	}
	
	public String toString() {
		return "[this.group]" + group +
		"[this.groupSeq] " + groupSeq +
		"[this.seq]"  + seq +		
		"[this.name]" + name +
		"[this.type]" + type +
		"[this.ftpIP]" + ftpIP +
		"[this.ftpPort]" + ftpPort +
		"[this.ftpID]" + ftpID +
		"[this.ftpPass]" + ftpPass +
		"[this.ftpMode]" + ftpMode +
		"[this.path]" + path +
		"[this.realPath]" + realPath +
		"[this.delaySecond]" + delaySecond +
		"[this.font]" + font +
		"[this.fontSize]" + fontSize +
		"[this.fontcolor]" + fontcolor +
		"[this.backGroundColor]" + backGroundColor+
		"[this.alalrmBackColor]" + alalrmBackColor +
		"[this.alalrmData]" + alalrmData +
		"[this.alarmType]" + alarmType +
		"[this.curBackColor]" + curBackColor +
		"[this.lineCount]" + lineCount;		
	}

	/**
	 * @[ ϰ ]  ڿ SimpleDateFormat ٲپ ϸ .
	 * 
	 * @return
	 */
	public String getRealPath() {
		realPath = getPath();
		
		int startConv = StringUtils.indexOf(getPath(), "@[");		
		if(startConv != -1) {
			int endConv = StringUtils.indexOf(getPath(), "]");			
			String beforeConvData = StringUtils.substring(getPath(), startConv+ 2, endConv);
			
			SimpleDateFormat dateFormat = new SimpleDateFormat(beforeConvData);
			String convData = dateFormat.format(new Date());
			
			realPath = StringUtils.substring(getPath(), 0, startConv);
			realPath += convData;
			realPath += StringUtils.substring(getPath(), endConv + 1 , getPath().length()); 
		}
		
		return realPath;
	}

	public void setRealPath(String realPath) {
		this.realPath = realPath;
	}
}
